/* sample program of mixed C code and asm code */

#include <hc11.h>
#define LED (*(volatile unsigned char*)0x1404)

typedef void (*fnptr)();
#define lcd_ini ((fnptr)0x80f)

void lcd_line1(char, char*);
void lcd_line2(char, char*);
void get_date(char*);
void get_time(char*);
void delay1ms(short);

int main()
{
    char line1[] = "Hello There";
    char line2[] = "Prof. Chen ";
    char buf[12];
    char image = 0x55;

    lcd_ini();
    lcd_line1(11, line1);      // do signon message
    lcd_line2(10, line2);
    
    delay1ms(1000);
    lcd_ini();
    
    while(1) {                 // get date and time and display them
        LED = image;
        image ^= 0xff;
        get_date(buf);
        lcd_line1(10, buf);
        get_time(buf);
        lcd_line2(11, buf);
        delay1ms(100);
    }

    return 0;
}
